/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.gametest.quickexport;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.fabricators_of_create.porting_lib.gametest.quickexport.AreaSelection;
import io.github.fabricators_of_create.porting_lib.gametest.quickexport.AreaSelectorItem;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3499;

public class QuickExportCommand {
    public static final String OUTPUT_PROPERTY = "porting_lib.gametest.quickexport.output";
    private static final String property = System.getProperty("porting_lib.gametest.quickexport.output");
    private static final Path output = property != null ? Paths.get(property, new String[0]) : FabricLoader.getInstance().getGameDir().resolve("gametests");
    public static final class_2561 HOLD_SELECTOR = QuickExportCommand.lang("hold_selector", new Object[0]);
    public static final class_2561 FAILED = QuickExportCommand.lang("failed", new Object[0]);
    public static final class_2561 ESCAPE = QuickExportCommand.lang("escape", new Object[0]);

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, buildCtx, env) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"porting_lib").then(class_2170.method_9247((String)"quickexport").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).requires(source -> source.method_9259(2))).suggests(QuickExportCommand::getSuggestions).executes(ctx -> QuickExportCommand.handleExport((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"path")))))));
    }

    private static CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String path = builder.getRemaining();
        if (!path.contains("/") || path.contains("..")) {
            return QuickExportCommand.findInDir(output, builder);
        }
        int lastSlash = path.lastIndexOf("/");
        Path subDir = output.resolve(path.substring(0, lastSlash));
        return QuickExportCommand.findInDir(subDir, builder);
    }

    private static CompletableFuture<Suggestions> findInDir(Path dir, SuggestionsBuilder builder) {
        if (!Files.exists(dir, new LinkOption[0])) {
            return builder.buildFuture();
        }
        try (Stream<Path> paths = Files.list(dir);){
            paths.filter(p -> Files.isDirectory(p, new LinkOption[0]) || p.toString().endsWith(".nbt")).forEach(path -> {
                Object file = path.toString().replaceAll("\\\\", "/").substring(output.toString().length() + 1);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    file = (String)file + "/";
                }
                builder.suggest((String)file);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.buildFuture();
    }

    private static int handleExport(class_2168 source, String path) throws CommandSyntaxException {
        if (((String)path).contains("..")) {
            source.method_9213(ESCAPE);
            return 0;
        }
        class_3222 player = source.method_9207();
        AreaSelection area = AreaSelectorItem.getArea(player.method_6047());
        if (area == null || area.second == null) {
            source.method_9213(HOLD_SELECTOR);
            return 0;
        }
        class_3341 box = area.asBoundingBox();
        class_2338 origin = new class_2338(box.method_35415(), box.method_35416(), box.method_35417());
        class_2382 bounds = new class_2382(box.method_35414(), box.method_14660(), box.method_14663());
        class_3218 level = source.method_9225();
        class_3499 structure = new class_3499();
        structure.method_15174((class_1937)level, origin, bounds, true, class_2246.field_10124);
        class_2487 data = structure.method_15175(new class_2487());
        if (!((String)path).endsWith(".nbt")) {
            path = (String)path + ".nbt";
        }
        Path file = output.resolve((String)path).toAbsolutePath();
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.deleteIfExists(file);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE);){
                class_2507.method_10634((class_2487)data, (OutputStream)out);
            }
            String cleanPath = file.toString().replace('\\', '/');
            source.method_9226(() -> QuickExportCommand.lang("exported", cleanPath), false);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            source.method_9213(FAILED);
            return 0;
        }
    }

    private static class_2561 lang(String type, Object ... args) {
        return class_2561.method_43469((String)("quickexport.command.feedback." + type), (Object[])args);
    }
}

